<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ForumPost extends Model
{
    use HasFactory;

    protected $fillable = [
        'thread_id',
        'user_id',
        'content',
    ];

    public function thread(): BelongsTo
    {
        return $this->belongsTo(ForumThread::class, 'thread_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function reactions()
    {
        return $this->morphMany(ForumReaction::class, 'reactable');
    }
    
    public function getReactionCount(string $type)
    {
        return $this->reactions()->where('type', $type)->count();
    }
    
    public function hasReactionFromUser($userId, $type)
    {
        return $this->reactions()
            ->where('user_id', $userId)
            ->where('type', $type)
            ->exists();
    }
}